/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import xaero.map.region.MapTileChunk;
import xaeroplus.feature.extensions.SeenChunksTrackingMapTileChunk;
import xaeroplus.util.ChunkUtils;

public class DrawHelper {
    public static void addMMBackgroundToBuffer(Matrix4f matrix, class_4588 bufferBuilder, int drawX, int drawY, MapTileChunk chunk) {
        int tileIndexX;
        boolean[][] seenTiles = ((SeenChunksTrackingMapTileChunk)chunk).getSeenTiles();
        boolean hasEmptyTiles = false;
        boolean hasTexturedTiles = false;
        for (tileIndexX = 0; tileIndexX < 4; ++tileIndexX) {
            for (int tileIndexZ = 0; tileIndexZ < 4; ++tileIndexZ) {
                if (seenTiles[tileIndexX][tileIndexZ]) {
                    hasTexturedTiles = true;
                    continue;
                }
                hasEmptyTiles = true;
            }
        }
        if (!hasTexturedTiles) {
            return;
        }
        if (!hasEmptyTiles) {
            DrawHelper.drawBg(matrix, bufferBuilder, drawX, drawY, drawX + 64, drawY + 64);
            return;
        }
        for (tileIndexX = 0; tileIndexX < 4; ++tileIndexX) {
            int top = 0;
            int bottom = 0;
            boolean columnStarted = false;
            int left = drawX + ChunkUtils.mapTileCoordToCoord(tileIndexX);
            int right = left + 16;
            for (int tileIndexY = 0; tileIndexY < 4; ++tileIndexY) {
                if (seenTiles[tileIndexX][tileIndexY]) {
                    int nextTop = drawY + ChunkUtils.mapTileCoordToCoord(tileIndexY);
                    bottom = nextTop + 16;
                    if (columnStarted) continue;
                    top = nextTop;
                    columnStarted = true;
                    continue;
                }
                if (!columnStarted) continue;
                DrawHelper.drawBg(matrix, bufferBuilder, left, top, right, bottom);
                columnStarted = false;
            }
            if (!columnStarted) continue;
            DrawHelper.drawBg(matrix, bufferBuilder, left, top, right, bottom);
        }
    }

    static void drawBg(Matrix4f matrix, class_4588 bufferBuilder, float x1, float y1, float x2, float y2) {
        DrawHelper.fillIntoExistingBuffer(matrix, bufferBuilder, x1, y1, x2, y2, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static void fillIntoExistingBuffer(Matrix4f matrix, class_4588 bufferBuilder, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        bufferBuilder.method_22918((Matrix4fc)matrix, x1, y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918((Matrix4fc)matrix, x2, y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918((Matrix4fc)matrix, x2, y1, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918((Matrix4fc)matrix, x1, y1, 0.0f).method_22915(r, g, b, a);
    }

    public static void addColoredLineToExistingBuffer(class_4587.class_4665 matrices, class_4588 vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a, float lineWidth) {
        vertexBuffer.method_22918((Matrix4fc)matrices.method_23761(), x1, y1, 0.0f).method_22915(r, g, b, a).method_60831(matrices, x2 - x1, y2 - y1, 0.0f).method_75298(lineWidth);
        vertexBuffer.method_22918((Matrix4fc)matrices.method_23761(), x2, y2, 0.0f).method_22915(r, g, b, a).method_60831(matrices, x2 - x1, y2 - y1, 0.0f).method_75298(lineWidth);
    }
}

